### 概述

FTP（File Transfer Protocol，文件传输协议）是一种用于在网络上在客户端与服务器之间传输文件的标准网络协议，属于TCP/IP协议族中的应用层协议。核心功能：实现文件的上传（Client->Server）和下载（Server->Client）,支持目录操作（列出、创建、删除等）。



**使用场景**

* 同一台设备实时域与非实时域的文件传出。

* 不同设备非实时域与设备实时域的文件传出。

**整体架构**

![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac18d30a6c4.png)


* 注： 本手册中用到的中科时代的软件包，均可以从官网的子页面获取。官网提供的版本可能比本手册中提到的版本更高，一般情况下这不会影响您按照本手册的例子执行相应的操作

* 下表概述了各个产品组件

|        | **产品组件**                            | **描述说明**                          |
| ------ | ----------------------------------- | --------------------------------- |
| Client | SF4201\_FtpClient\_1.0.4\_amd64.deb | FTP Client RTE组件                  |
|        | ftpClient.library                   | FTP Client Master Metafacture 库文件 |

### 安装卸载

**安装要求**

* 中科时代出厂的工智机；

* 安装DeviceManager.exe (0.0.2.4)软件

**安装过程**

**工智机端安装FTP Client RTE组件**

* 运行DeviceManager.exe 软件

* 安装ACP 服务（以工智机IP（192.168.105.20）为例），选择“在线安装”
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac190d062a7.png)


* 选择工智机（192.168.105.20），点击“本地”，进入本地安装界面；
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac1913e17af.png)


* 进入工智机设备管理器界面，点击"软件”下拉选择“组件管理”，进入“浏览页面”，选择"FTPClient"查看安装版本并点击“安装”；
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac19180f074.png)


* 传输完成，弹窗选择确定安装；安装完成后，选择确认重启组件；

* 安装完成后，本地新增1.0.1版本的"FTPClient"组件，
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac191bbb52d.png)


**Metafacture安装library**

* 打开Metafacture，点击“工具”  -- “库存储”
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac193f618af.png)


* 点击“安装” -- 选中modbus master的库文件，点击“打开”
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac1943e8822.png)
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac197463e12.jpeg)


* 工程中点击“库管理器” -- “添加库” -- 选中FTPClient库点击“确定”
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac19778c40f.jpeg)


**卸载过程**

**工智机端卸载FTPClient RTE组件**

* 进入工智机设备管理器->“组件管理界面”->"本地”，选择组件"FTPClient" 点击“卸载”；
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac198750f4b.png)


* 确认卸载组件且确定重新加载；
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac198abc25b.png)


* 加载完成后，"FTPClient" 组件被删除；

**卸载MetaFacture侧的FTPClient library**

* MetaFacture界面点击“工具” -- “库存储”&#x20;
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac19910f298.png)


* 对话框中选中安装的FTPClient的库，点击“卸载”
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac1995070e2.jpeg)
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac199532131.png)




### 技术说明

#### 快速启动

**本例软、硬件配置**

硬件：
1.SX21工智机
2.Win10 PC	

软件：
1.MetaFacutre V1.0.7.1


**本例实验要求及原理**

实验要求：按照“安装卸载”部分中的“安装过程”配置完成FTPClient环境

**实验环境**

**&#x20;**&#x6309;照“概述”部分中的“使用场景”搭建测试环境。

#### 本例实验操作步骤

**FTP 连接测试**

#### FTP 连接

实验步骤如下：

* POU中声明区域调用FB\_FtpConnect&#x20;

```shell
Connect   	:TMP.FB_FtpConnect ;
ip1 			: STRING(15):='192.168.105.44';   //FTP Server IP_addr
user 		        : STRING(15):='sinsegye';             //FTP Server username
pwd			: STRING(15):='1';		              //FTP Server password
bFTPConnect : BOOL;
handle 		: UINT;
```



* POU中程序区域调用ReadCoils

```shell
Connect(
sIp:=ip, 
sUser:=user, 
sPwd:=pwd, 
bExecute:=bFTPConnect,
tTimeout:=, 
uHandle=>handle4,
 bError=>, bBusy=>, uErrorId=>);
```

* 工程运行后触发Connect中的bExecute上升沿执行连接FTPServer；
* MetaFacture配置程序暂停并重新运行，获取结果如下：
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac1a4108def.jpeg)

#### FTP 断开连接

实验步骤如下：

* POU中声明区域调用FB\_FtpDisConnect&#x20;

```shell
DisConnect             : TMP.FB_FtpDisconnect;
bDisConnExe	       :BOOL;
```
* POU中程序区域调用disConnect

```shell
DisConnect(
uHandle:=handle , 
bExecute:=bDisConnExe , 
tTimeout:= , 
bError=> , bBusy=> , uErrorId=> , bIsSuccess=> );
```



* 工程运行后触发disConnect中的bExecute上升沿执行断开FTP Server连接；




* MetaFacture配置程序暂停并重新运行，获取结果如下：
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac1a8488740.jpeg)

#### FTP 文件夹操作

**创建文件夹**

实验步骤如下：

* POU中声明区域调用FB\_FtpDirCreate&#x20;

```shell
bDirCreatExe	:BOOL;
DirCreate	        : TMP.FB_FtpDirCreate;
sDirectory		: STRING(80);
```

* POU中程序区域调用FB\_FtpDirCreate

```shell
sDirectory		:='Debug';   
DirCreate(
uHandle:=handle, 
sDirectory:=sDirectory, 
bExecute:=bDirCreatExe,
tTimeout:=);
```



* 工程运行后触发dirCreate中的bExecute上升沿执行创建文件夹操作;

* MetaFacture配置程序暂停并重新运行，获取结果如下
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac1b6506e2a.jpeg)


**检测文件夹**

实验步骤如下：

* POU中声明区域调用FB\_FtpDirExists&#x20;

```shell
bDirExistsExe	:BOOL;
DirExists	        : TMP.FB_FtpDirExists;
sDirectory		: STRING(80);
```


* POU中程序区域调用FB\_FtpDirExists

```shell
sDirectory		:='Debug';   
DirExists(
uHandle:= handle,
       sDirectory:=sDirectory, 
bExecute:= bDirExistsExe, 
tTimeout:= , 
bError=> , bBusy=> , uErrorId=> , bIsSuccess=> );
```


* 工程运行后触发dirExistse中的bExecute上升沿执行检测文件夹操作;

* MetaFacture配置程序暂停并重新运行，获取结果如下：
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac1b96389ba.jpeg)


**文件夹重命名**

实验步骤如下：

* POU中声明区域调用FB\_FtpDirRename&#x20;

```shell
bDirRenamesExe	:BOOL;
DirRename 	        : TMP.FB_FtpDirRename;
sDirectory		        : STRING(80);
sNewDirName		: STRING(80);
```


* POU中程序区域调用FB\_FtpDirRename

```shell
sDirectory		:='Debug';   
sNewDirName  :='Debug_NewName';
DirRename(
uHandle:=handle, 
sDirectory:=sDirectory, 
sNewName:=sNewDirName,
bExecute:=bDirRenamesExe,
tTimeout:= , 
bError=> , bBusy=> , uErrorId=> , bIsSuccess=> );
```


* 工程运行后触发dirRename中的bExecute上升沿执行重命名文件夹操作;

* MetaFacture配置程序暂停并重新运行，获取结果如下：
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac1bc768c4b.jpeg)


**文件夹移动**

实验步骤如下：

* POU中声明区域调用FB\_FtpDirMove&#x20;
```shell
bDirMoveExe		:BOOL;
DirMove 	                 : TMP.FB_FtpDirMove;
sDirectory		        : STRING(80);
sDirectory	2		: STRING(80);
```

* POU中程序区域调用FB\_FtpDirRename
```shell
sDirectory		:='Debug';   
sDirectory2	:='Debug_01';
DirMove(
uHandle:=handle , 
sDirectory:=sDirectory , 
sTargetDirectory:=sDirectory2 , 
bExecute:=bDirMoveExe ,
tTimeout:= , 
bError=> , bBusy=> , uErrorId=> , bIsSuccess=> );
```

* 工程运行后触发dirMove中的bExecute上升沿执行移动文件夹操作;

* MetaFacture配置程序暂停并重新运行，获取结果如下：
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac1e9d1ba53.jpeg)

**删除文件夹**

实验步骤如下：

* POU中声明区域调用FB\_FtpDirMove&#x20;
```shell
bDirRemoveExe	:BOOL;
DirRemove 	        : TMP.FB_FtpDirRemove;
sDirectory		        : STRING(80);
```

* POU中程序区域调用FB\_FtpDirRename
```shell
sDirectory		:='Debug';   
DirRemove(
uHandle:=handle , 
sDirectory:=sDirectory , 
bExecute:=bDirRemoveExe ,
tTimeout:= , 
bError=> , bBusy=> , uErrorId=> , bIsSuccess=> );
```
* 工程运行后触发dirRemove中的bExecute上升沿执行删除文件夹操作;

* MetaFacture配置程序暂停并重新运行，获取结果如下：
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac1ecb97d39.jpeg)


#### FTP 文件操作

**检测文件**

实验步骤如下：

* POU中声明区域调用FB\_FtpFileExists&#x20;
```shell
bFileExistsExe	       :BOOL;
FileExists 	               : TMP.FB_FtpFileExists;
FileSourcePath	: STRING(80);
```

* POU中程序区域调用FB\_FtpDirExists

```shell
FileSourcePath 	:='Debug/test.txt';  
FileExists(
uHandle:= handle,
       sFilePath:=FileSourcePath, 
bExecute:= bFileExistsExe, 
tTimeout:= , 
bError=> , bBusy=> , uErrorId=> , bIsSuccess=> );
```


* 工程运行后触发fileExists中的bExecute上升沿执行检测文件操作;

* MetaFacture配置程序暂停并重新运行，获取结果如下：
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac20d8648bd.jpeg)


**文件重命名**

实验步骤如下：

* POU中声明区域调用FB\_FtpFileRename&#x20;

```shell
bFileRenamesExe	:BOOL;
FileRename 	: TMP.FB_FtpFileRename;
FileSourcePath	: STRING(80);
FileNewName		: STRING(80);
```

* POU中程序区域调用FB\_FtpDirRename


```shell
FileSourcePath 	:='Debug/test.txt';  
FileNewName		:='File_newname.text';
FileRename(
uHandle:=handle, 
sFilePath:=FileSourcePath, 
sNewName:=FileNewName, 
bExecute:=bFileRenamesExe,
tTimeout:= , 
bError=> , bBusy=> , uErrorId=> , bIsSuccess=> );
```


* 工程运行后触发fileRename中的bExecute上升沿执行重命名文件夹操作;

* MetaFacture配置程序暂停并重新运行，获取结果如下：
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac20ff3b6b4.jpeg)


**文件移动**

实验步骤如下：

* POU中声明区域调用FB\_FtpFileMove&#x20;

```shell
bFileMoveExe	        :BOOL;
FileMove 	                : TMP.FB_FtpFileMove;
FileSourcePath 	:STRING(80); 
TargetDirectory		: STRING(80);
```


* POU中程序区域调用FB\_FtpDirRename

```shell
FileSourcePath 	:='Debug/test.txt';  
TargetDirectory		:='/Debug_01'; 
FileMove(
uHandle:=handle, 
sFilePath:=FileSourcePath, 
sTargetDirectory:=TargetDirectory, 
bExecute:=bFileMoveExe ,
tTimeout:= , 
bError=> , bBusy=> , uErrorId=> , bIsSuccess=> );
```


* 工程运行后触发fileMove中的bExecute上升沿执行移动文件操作;

* MetaFacture配置程序暂停并重新运行，获取结果如下：
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac212fc8dda.jpeg)


**删除文件**

实验步骤如下：

* POU中声明区域调用FB\_FtpFileRemove&#x20;

```shell
bFileRemoveExe	:BOOL;
FileRemove 	        : TMP.FB_FtpFileRemove;
FileSourcePath 	:STRING(80); 
```


* POU中程序区域调用FB\_FtpDirRename
```shell
FileSourcePath 	        :='Debug/test.txt';  
LocalTargetDirectory 	:='/home/sinsegye/test'; // RTE本地文件夹
Download(
uHandle:=handle,
sServerSourcePath:=FileSourcePath, sLocalTargetDirectory:=localTargetDirectory, bExecute:=bdownloadExe,
tTimeout:= , 
bError=> , 
bBusy=> , 
uErrorId=> , 
bIsSuccess=> );
```

* 工程运行后触发fileRemove中的bExecute上升沿执行删除文件夹操作;
* MetaFacture配置程序暂停并重新运行，获取结果如下：
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac23b36b903.jpeg)


**文件下载**

实验步骤如下：

* POU中声明区域调用FB\_FtpDownload&#x20;
```shell
bdownloadExe  	         :BOOL;
Download 	                 : TMP.FB_FtpDownload;
FileSourcePath 	         :STRING(80); 
LocalTargetDirectory 	: STRING(80);
```
* POU中程序区域调用FB\_FtpDirRename
```shell
FileSourcePath 	        :='Debug/test.txt';  
LocalTargetDirectory 	:='/home/sinsegye/test'; // RTE本地文件夹
Download(
uHandle:=handle,
sServerSourcePath:=FileSourcePath, sLocalTargetDirectory:=localTargetDirectory, bExecute:=bdownloadExe,
tTimeout:= , 
bError=> , 
bBusy=> , 
uErrorId=> , 
bIsSuccess=> );
```

* 工程运行后触发download中的bExecute上升沿执行文件下载操作;

* MetaFacture配置程序暂停并重新运行，获取结果如下：
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac264434d2d.jpeg)

**文件上传**

实验步骤如下：

* POU中声明区域调用FB\_FtpUpload&#x20;

```shell
bdownloadExe  	         :BOOL;
Upload 		                 : TMP.FB_FtpUpload;
TargetDirectory 	         :STRING(80); 
LocalTargetDirectory 	: STRING(80);
```


* POU中程序区域调用FB\_FtpDirRename

```shell
TargetDirectory			:='/Debug_01'; 
LocalTargetDirectory 	:='/home/sinsegye/test'; // RTE本地文件夹
Upload(
uHandle:=handle,
sLocalSourcePath:=LocalTargetDirectory, sServerTargetDirectory:=TargetDirectory, 
bExecute:=bUploadExe,
tTimeout:= , 
bError=> , 
bBusy=> , 
uErrorId=> , 
bIsSuccess=> );
```

* 工程运行后触发download中的bExecute上升沿执行文件下载操作;

* MetaFacture配置程序暂停并重新运行，获取结果如下：
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac266c9cd8a.jpeg)

---

### 功能介绍

#### FTP连接功能块介绍

**功能块图形**
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac26707dcb0.jpeg)


**参数介绍**

* 输入参数

| 参数名称     | 参数类型   | 描述         |
| -------- | ------ | ---------- |
| sIP      | string | FTP 服务IP   |
| sUser    | UINT   | FTP 服务用户名  |
| sPwd     | BYTE   | FTP 服务用户密码 |
| bExecute | BOOL   | 上升沿触发执行    |
| tTimeout | Time   | 超时         |

* 输出参数

| 参数名称       | 参数类型  | 描述                                 |
| ---------- | ----- | ---------------------------------- |
| uHandle    | UNIT  |                                    |
| bBUSY      | BOOL  | 功能块激活时设置，直到确认接收                    |
| bError     | BOOL  | 如果命令在传输过程中出现错误，则设置true直到bBusy输出被重置 |
| nErrId     | UDINT | 当bError输出被设置，提供错误号                 |
| bIsSuccess | BOOL  | 功能成功返回True                         |

#### FTP断开连接功能块介绍

**功能块图形**
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac2675a8b79.jpeg)


**参数介绍**

* 输入参数

| 参数名称     | 参数类型 | 描述      |
| -------- | ---- | ------- |
| uHandle  | UNIT |         |
| bExecute | BOOL | 上升沿触发执行 |
| tTimeout | Time | 超时      |

* 输出参数

| 参数名称       | 参数类型  | 描述                                 |
| ---------- | ----- | ---------------------------------- |
| bBUSY      | BOOL  | 功能块激活时设置，直到确认接收                    |
| bError     | BOOL  | 如果命令在传输过程中出现错误，则设置true直到bBusy输出被重置 |
| nErrId     | UDINT | 当bError输出被设置，提供错误号                 |
| bIsSuccess | BOOL  | 功能成功返回True                         |



#### FTP创建文件夹功能块介绍

**功能块图形**
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac2679cd07d.jpeg)


**参数介绍**

* 输入参数

| 参数名称       | 参数类型   | 描述      |
| ---------- | ------ | ------- |
| uHandle    | UNIT   |         |
| sDirectory | STRING | 文件夹名称   |
| bExecute   | BOOL   | 上升沿触发执行 |
| tTimeout   | Time   | 超时      |

* 输出参数

| 参数名称       | 参数类型  | 描述                                 |
| ---------- | ----- | ---------------------------------- |
| bBUSY      | BOOL  | 功能块激活时设置，直到确认接收                    |
| bError     | BOOL  | 如果命令在传输过程中出现错误，则设置true直到bBusy输出被重置 |
| nErrId     | UDINT | 当bError输出被设置，提供错误号                 |
| bIsSuccess | BOOL  | 功能成功返回True                         |



#### FTP文件夹检查功能块介绍

**功能块图形**
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac267e74b3e.jpeg)


**参数介绍**

* 输入参数

| 参数名称       | 参数类型   | 描述      |
| ---------- | ------ | ------- |
| uHandle    | UNIT   |         |
| sDirectory | STRING | 文件夹名称   |
| bExecute   | BOOL   | 上升沿触发执行 |
| tTimeout   | Time   | 超时      |

* 输出参数

| 参数名称       | 参数类型  | 描述                                 |
| ---------- | ----- | ---------------------------------- |
| bBUSY      | BOOL  | 功能块激活时设置，直到确认接收                    |
| bError     | BOOL  | 如果命令在传输过程中出现错误，则设置true直到bBusy输出被重置 |
| nErrId     | UDINT | 当bError输出被设置，提供错误号                 |
| bIsSuccess | BOOL  | True表示存在，False 表示不存在               |



#### FTP文件夹重命名功能块介绍

**功能块图形**
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac26842c923.jpeg)


**参数介绍**

* 输入参数

| 参数名称       | 参数类型   | 描述      |
| ---------- | ------ | ------- |
| uHandle    | UNIT   |         |
| sDirectory | STRING | 文件夹名称   |
| sNewName   | STRING | 新文件夹名称  |
| bExecute   | BOOL   | 上升沿触发执行 |
| tTimeout   | Time   | 超时      |

* 输出参数

| 参数名称       | 参数类型  | 描述                                 |
| ---------- | ----- | ---------------------------------- |
| bBUSY      | BOOL  | 功能块激活时设置，直到确认接收                    |
| bError     | BOOL  | 如果命令在传输过程中出现错误，则设置true直到bBusy输出被重置 |
| nErrId     | UDINT | 当bError输出被设置，提供错误号                 |
| bIsSuccess | BOOL  | 功能成功返回True                         |



#### FTP文件夹移动功能块介绍

**功能块图形**
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac268a19898.jpeg)


**参数介绍**

* 输入参数

| 参数名称             | 参数类型   | 描述      |
| ---------------- | ------ | ------- |
| uHandle          | UNIT   |         |
| sDirectory       | STRING | 文件夹名称   |
| sTargetDirectory | STRING | 目标文件夹   |
| bExecute         | BOOL   | 上升沿触发执行 |
| tTimeout         | Time   | 超时      |

* 输出参数

| 参数名称       | 参数类型  | 描述                                 |
| ---------- | ----- | ---------------------------------- |
| bBUSY      | BOOL  | 功能块激活时设置，直到确认接收                    |
| bError     | BOOL  | 如果命令在传输过程中出现错误，则设置true直到bBusy输出被重置 |
| nErrId     | UDINT | 当bError输出被设置，提供错误号                 |
| bIsSuccess | BOOL  | 功能成功返回True                         |



#### FTP文件夹移除功能块介绍

**功能块图形**
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac268e80773.jpeg)


**参数介绍**

* 输入参数

| 参数名称       | 参数类型   | 描述      |
| ---------- | ------ | ------- |
| uHandle    | UNIT   |         |
| sDirectory | STRING | 文件夹名称   |
| bExecute   | BOOL   | 上升沿触发执行 |
| tTimeout   | Time   | 超时      |

* 输出参数

| 参数名称       | 参数类型  | 描述                                 |
| ---------- | ----- | ---------------------------------- |
| bBUSY      | BOOL  | 功能块激活时设置，直到确认接收                    |
| bError     | BOOL  | 如果命令在传输过程中出现错误，则设置true直到bBusy输出被重置 |
| nErrId     | UDINT | 当bError输出被设置，提供错误号                 |
| bIsSuccess | BOOL  | 功能成功返回True                         |



#### FTP文件检查功能块介绍

**功能块图形**
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac26927ee94.jpeg)


**参数介绍**

* 输入参数

| 参数名称      | 参数类型   | 描述       |
| --------- | ------ | -------- |
| uHandle   | UNIT   |          |
| SFilePath | STRING | 文件路径+文件名 |
| bExecute  | BOOL   | 上升沿触发执行  |
| tTimeout  | Time   | 超时       |

* 输出参数

| 参数名称       | 参数类型  | 描述                                 |
| ---------- | ----- | ---------------------------------- |
| bBUSY      | BOOL  | 功能块激活时设置，直到确认接收                    |
| bError     | BOOL  | 如果命令在传输过程中出现错误，则设置true直到bBusy输出被重置 |
| nErrId     | UDINT | 当bError输出被设置，提供错误号                 |
| bIsSuccess | BOOL  | True表示存在，False 表示不存在               |



#### FTP文件重命名功能块介绍

**功能块图形**
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac2696b7bb7.jpeg)


**参数介绍**

* 输入参数

| 参数名称      | 参数类型   | 描述       |
| --------- | ------ | -------- |
| uHandle   | UNIT   |          |
| sFilePath | STRING | 文件路径+文件名 |
| sNewName  | STRING | 新文件名称    |
| bExecute  | BOOL   | 上升沿触发执行  |
| tTimeout  | Time   | 超时       |

* 输出参数

| 参数名称       | 参数类型  | 描述                                 |
| ---------- | ----- | ---------------------------------- |
| bBUSY      | BOOL  | 功能块激活时设置，直到确认接收                    |
| bError     | BOOL  | 如果命令在传输过程中出现错误，则设置true直到bBusy输出被重置 |
| nErrId     | UDINT | 当bError输出被设置，提供错误号                 |
| bIsSuccess | BOOL  | 功能成功返回True                         |



#### FTP文件移动功能块介绍

**功能块图形**
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac269b6bfe0.jpeg)


**参数介绍**

* 输入参数

| 参数名称             | 参数类型   | 描述       |
| ---------------- | ------ | -------- |
| uHandle          | UNIT   |          |
| sFilePath        | STRING | 文件路径+文件名 |
| sTargetDirectory | STRING | 目标文件夹    |
| bExecute         | BOOL   | 上升沿触发执行  |
| tTimeout         | Time   | 超时       |

* 输出参数

| 参数名称       | 参数类型  | 描述                                 |
| ---------- | ----- | ---------------------------------- |
| bBUSY      | BOOL  | 功能块激活时设置，直到确认接收                    |
| bError     | BOOL  | 如果命令在传输过程中出现错误，则设置true直到bBusy输出被重置 |
| nErrId     | UDINT | 当bError输出被设置，提供错误号                 |
| bIsSuccess | BOOL  | 功能成功返回True                         |



#### FTP文件移除功能块介绍

**功能块图形**
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac26a044c2b.jpeg)


**参数介绍**

* 输入参数

| 参数名称      | 参数类型   | 描述       |
| --------- | ------ | -------- |
| uHandle   | UNIT   |          |
| sFilePath | STRING | 文件路径+文件名 |
| bExecute  | BOOL   | 上升沿触发执行  |
| tTimeout  | Time   | 超时       |

* 输出参数

| 参数名称       | 参数类型  | 描述                                 |
| ---------- | ----- | ---------------------------------- |
| bBUSY      | BOOL  | 功能块激活时设置，直到确认接收                    |
| bError     | BOOL  | 如果命令在传输过程中出现错误，则设置true直到bBusy输出被重置 |
| nErrId     | UDINT | 当bError输出被设置，提供错误号                 |
| bIsSuccess | BOOL  | 功能成功返回True                         |



#### FTP文件下载功能块介绍

**功能块图形**
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac26a447d50.jpeg)


**参数介绍**

* 输入参数

| 参数名称                  | 参数类型   | 描述      |
| --------------------- | ------ | ------- |
| uHandle               | UNIT   |         |
| sServerSourcePath     | STRING | 服务端源路径  |
| sLocalTargetDirectory | STRING | 本地目标路径  |
| bExecute              | BOOL   | 上升沿触发执行 |
| tTimeout              | Time   | 超时      |

* 输出参数

| 参数名称       | 参数类型  | 描述                                 |
| ---------- | ----- | ---------------------------------- |
| bBUSY      | BOOL  | 功能块激活时设置，直到确认接收                    |
| bError     | BOOL  | 如果命令在传输过程中出现错误，则设置true直到bBusy输出被重置 |
| nErrId     | UDINT | 当bError输出被设置，提供错误号                 |
| bIsSuccess | BOOL  | 功能成功返回True                         |



#### FTP文件上传功能块介绍

**功能块图形**
![](https://resource.helplook.net/docker_production/3648ne/article/YSYQbJM3/68ac26a887069.jpeg)


**参数介绍**

* 输入参数

| 参数名称                   | 参数类型   | 描述      |
| ---------------------- | ------ | ------- |
| uHandle                | UNIT   |         |
| sLocalSourcePath       | STRING | 本地源路径   |
| sServerTargetDirectory | STRING | 服务端目标路径 |
| bExecute               | BOOL   | 上升沿触发执行 |
| tTimeout               | Time   | 超时      |

* 输出参数

| 参数名称       | 参数类型  | 描述                                 |
| ---------- | ----- | ---------------------------------- |
| bBUSY      | BOOL  | 功能块激活时设置，直到确认接收                    |
| bError     | BOOL  | 如果命令在传输过程中出现错误，则设置true直到bBusy输出被重置 |
| nErrId     | UDINT | 当bError输出被设置，提供错误号                 |
| bIsSuccess | BOOL  | 功能成功返回True                         |